%------------------------------------------------------------------------------
% File     : DAT211^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Splay tree analysis 105
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Nip14] Nipkow (2014), Amortized Complexity Verified
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : splay_tree_analysis__105.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.5.0, 0.33 v7.2.0, 0.50 v7.1.0
% Syntax   : Number of formulae    :  336 ( 159 unt;  52 typ;   0 def)
%            Number of atoms       :  648 ( 264 equ;   0 cnn)
%            Maximal formula atoms :    8 (   2 avg)
%            Number of connectives : 4227 (  49   ~;   9   |;  17   &;3947   @)
%                                         (   0 <=>; 205  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   6 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   60 (  60   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   48 (  47 usr;  12 con; 0-4 aty)
%            Number of variables   :  591 (   9   ^; 543   !;  10   ?; 591   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:49:04.965
%------------------------------------------------------------------------------
%----Could-be-implicit typings (8)
thf(ty_t_Tree_Otree,type,
    tree: $tType > $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Num_Onum,type,
    num: $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (44)
thf(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Onumeral,type,
    numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Osemiring__numeral,type,
    semiring_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

thf(sy_c_Num_Onum_OBit0,type,
    bit0: num > num ).

thf(sy_c_Num_Onum_OBit1,type,
    bit1: num > num ).

thf(sy_c_Num_Onum_OOne,type,
    one: num ).

thf(sy_c_Num_Onumeral__class_Onumeral,type,
    numeral_numeral: 
      !>[A: $tType] : ( num > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Splay__Tree_Osplay,type,
    splay_splay: 
      !>[A: $tType] : ( A > ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_Splay__Tree__Analysis__Mirabelle__pcaxyvimtd_OA,type,
    splay_266122055elle_A: 
      !>[A: $tType] : ( A > ( tree @ A ) > real ) ).

thf(sy_c_Transcendental_Olog,type,
    log: real > real > real ).

thf(sy_c_Tree_Olinorder__class_Obst,type,
    linorder_bst: 
      !>[A: $tType] : ( ( tree @ A ) > $o ) ).

thf(sy_c_Tree_Osize1,type,
    size1: 
      !>[A: $tType] : ( ( tree @ A ) > nat ) ).

thf(sy_c_Tree_Osubtrees,type,
    subtrees: 
      !>[A: $tType] : ( ( tree @ A ) > ( set @ ( tree @ A ) ) ) ).

thf(sy_c_Tree_Otree_OLeaf,type,
    leaf: 
      !>[A: $tType] : ( tree @ A ) ).

thf(sy_c_Tree_Otree_ONode,type,
    node: 
      !>[A: $tType] : ( ( tree @ A ) > A > ( tree @ A ) > ( tree @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a____,type,
    a2: a ).

thf(sy_v_b____,type,
    b: a ).

thf(sy_v_lb____,type,
    lb: tree @ a ).

thf(sy_v_lu____,type,
    lu: tree @ a ).

thf(sy_v_lx,type,
    lx: tree @ a ).

thf(sy_v_ra____,type,
    ra: tree @ a ).

thf(sy_v_rb____,type,
    rb: tree @ a ).

thf(sy_v_ru____,type,
    ru: tree @ a ).

thf(sy_v_rx,type,
    rx: tree @ a ).

thf(sy_v_u____,type,
    u: a ).

thf(sy_v_xa____,type,
    xa: a ).

%----Relevant facts (253)
thf(fact_0_sp,axiom,
    ( ( splay_splay @ a @ xa @ lb )
    = ( node @ a @ lu @ u @ ru ) ) ).

% sp
thf(fact_1__C6_Ohyps_C_I3_J,axiom,
    ( lb
   != ( leaf @ a ) ) ).

% "6.hyps"(3)
thf(fact_2__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062lu_Au_Aru_O_Asplay_Ax_Alb_A_061_A_092_060langle_062lu_M_Au_M_Aru_092_060rangle_062_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [Lu: tree @ a,U: a,Ru: tree @ a] :
        ( ( splay_splay @ a @ xa @ lb )
       != ( node @ a @ Lu @ U @ Ru ) ) ).

% \<open>\<And>thesis. (\<And>lu u ru. splay x lb = \<langle>lu, u, ru\<rangle> \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_3__092_060open_062_092_060lbrakk_0620_A_060_Areal_A_Isize1_Alb_J_059_A0_A_060_Areal_A_Isize1_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_J_092_060rbrakk_062_A_092_060Longrightarrow_062_A1_A_L_A_092_060phi_062_Alb_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_060_A2_A_K_Alog_A2_A_Ireal_A_Isize1_Alb_J_A_L_Areal_A_Isize1_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_J_J_092_060close_062,axiom,
    ( ( ord_less @ real @ ( zero_zero @ real ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) )
   => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) )
     => ( ord_less @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( one_one @ real ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( plus_plus @ real @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) ) ) ) ).

% \<open>\<lbrakk>0 < real (size1 lb); 0 < real (size1 \<langle>rb, a, ra\<rangle>)\<rbrakk> \<Longrightarrow> 1 + \<phi> lb + \<phi> \<langle>rb, a, ra\<rangle> < 2 * log 2 (real (size1 lb) + real (size1 \<langle>rb, a, ra\<rangle>))\<close>
thf(fact_4__C6_Ohyps_C_I2_J,axiom,
    ord_less @ a @ xa @ a2 ).

% "6.hyps"(2)
thf(fact_5__C6_Ohyps_C_I1_J,axiom,
    ord_less @ a @ xa @ b ).

% "6.hyps"(1)
thf(fact_6__C6_Oprems_C_I2_J,axiom,
    member @ ( tree @ a ) @ ( node @ a @ lx @ xa @ rx ) @ ( subtrees @ a @ ( node @ a @ ( node @ a @ lb @ b @ rb ) @ a2 @ ra ) ) ).

% "6.prems"(2)
thf(fact_7__C6_Oprems_C_I1_J,axiom,
    linorder_bst @ a @ ( node @ a @ ( node @ a @ lb @ b @ rb ) @ a2 @ ra ) ).

% "6.prems"(1)
thf(fact_8__092_060open_0622_A_K_A_092_060phi_062_Alb_A_L_A_092_060phi_062_A_092_060langle_062ru_M_Ab_M_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_092_060rangle_062_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lb_M_Ab_M_Arb_092_060rangle_062_A_N_A3_A_K_A_092_060phi_062_A_092_060langle_062lx_M_Ax_M_Arx_092_060rangle_062_A_L_A2_A_092_060le_062_A_092_060phi_062_Alb_A_L_A_092_060phi_062_A_092_060langle_062ru_M_Ab_M_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_092_060rangle_062_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_N_A3_A_K_A_092_060phi_062_A_092_060langle_062lx_M_Ax_M_Arx_092_060rangle_062_A_L_A2_092_060close_062,axiom,
    ord_less_eq @ real @ ( plus_plus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lb @ b @ rb ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( numeral_numeral @ real @ ( bit0 @ one ) ) ) @ ( plus_plus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( numeral_numeral @ real @ ( bit0 @ one ) ) ) ).

% \<open>2 * \<phi> lb + \<phi> \<langle>ru, b, \<langle>rb, a, ra\<rangle>\<rangle> + \<phi> \<langle>rb, a, ra\<rangle> - \<phi> \<langle>lb, b, rb\<rangle> - 3 * \<phi> \<langle>lx, x, rx\<rangle> + 2 \<le> \<phi> lb + \<phi> \<langle>ru, b, \<langle>rb, a, ra\<rangle>\<rangle> + \<phi> \<langle>rb, a, ra\<rangle> - 3 * \<phi> \<langle>lx, x, rx\<rangle> + 2\<close>
thf(fact_9__092_060open_0623_A_K_A_092_060phi_062_Alb_A_L_A_092_060phi_062_A_092_060langle_062ru_M_Ab_M_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_092_060rangle_062_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lb_M_Ab_M_Arb_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lu_M_Au_M_Aru_092_060rangle_062_A_N_A3_A_K_A_092_060phi_062_A_092_060langle_062lx_M_Ax_M_Arx_092_060rangle_062_A_L_A2_A_061_A2_A_K_A_092_060phi_062_Alb_A_L_A_092_060phi_062_A_092_060langle_062ru_M_Ab_M_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_092_060rangle_062_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lb_M_Ab_M_Arb_092_060rangle_062_A_N_A3_A_K_A_092_060phi_062_A_092_060langle_062lx_M_Ax_M_Arx_092_060rangle_062_A_L_A2_092_060close_062,axiom,
    ( ( plus_plus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lb @ b @ rb ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lu @ u @ ru ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( numeral_numeral @ real @ ( bit0 @ one ) ) )
    = ( plus_plus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lb @ b @ rb ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( numeral_numeral @ real @ ( bit0 @ one ) ) ) ) ).

% \<open>3 * \<phi> lb + \<phi> \<langle>ru, b, \<langle>rb, a, ra\<rangle>\<rangle> + \<phi> \<langle>rb, a, ra\<rangle> - \<phi> \<langle>lb, b, rb\<rangle> - \<phi> \<langle>lu, u, ru\<rangle> - 3 * \<phi> \<langle>lx, x, rx\<rangle> + 2 = 2 * \<phi> lb + \<phi> \<langle>ru, b, \<langle>rb, a, ra\<rangle>\<rangle> + \<phi> \<langle>rb, a, ra\<rangle> - \<phi> \<langle>lb, b, rb\<rangle> - 3 * \<phi> \<langle>lx, x, rx\<rangle> + 2\<close>
thf(fact_10_calculation,axiom,
    ord_less_eq @ real @ ( splay_266122055elle_A @ a @ xa @ ( node @ a @ ( node @ a @ lb @ b @ rb ) @ a2 @ ra ) ) @ ( plus_plus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( numeral_numeral @ real @ ( bit0 @ one ) ) ) ).

% calculation
thf(fact_11__092_060open_062A_Ax_Alb_A_L_A_092_060phi_062_A_092_060langle_062ru_M_Ab_M_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_092_060rangle_062_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lb_M_Ab_M_Arb_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lu_M_Au_M_Aru_092_060rangle_062_A_L_A1_A_092_060le_062_A3_A_K_A_092_060phi_062_Alb_A_L_A_092_060phi_062_A_092_060langle_062ru_M_Ab_M_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_092_060rangle_062_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lb_M_Ab_M_Arb_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lu_M_Au_M_Aru_092_060rangle_062_A_N_A3_A_K_A_092_060phi_062_A_092_060langle_062lx_M_Ax_M_Arx_092_060rangle_062_A_L_A2_092_060close_062,axiom,
    ord_less_eq @ real @ ( plus_plus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( splay_266122055elle_A @ a @ xa @ lb ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lb @ b @ rb ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lu @ u @ ru ) ) ) ) ) @ ( one_one @ real ) ) @ ( plus_plus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lb @ b @ rb ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lu @ u @ ru ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( numeral_numeral @ real @ ( bit0 @ one ) ) ) ).

% \<open>A x lb + \<phi> \<langle>ru, b, \<langle>rb, a, ra\<rangle>\<rangle> + \<phi> \<langle>rb, a, ra\<rangle> - \<phi> \<langle>lb, b, rb\<rangle> - \<phi> \<langle>lu, u, ru\<rangle> + 1 \<le> 3 * \<phi> lb + \<phi> \<langle>ru, b, \<langle>rb, a, ra\<rangle>\<rangle> + \<phi> \<langle>rb, a, ra\<rangle> - \<phi> \<langle>lb, b, rb\<rangle> - \<phi> \<langle>lu, u, ru\<rangle> - 3 * \<phi> \<langle>lx, x, rx\<rangle> + 2\<close>
thf(fact_12__092_060open_062A_Ax_A_092_060langle_062_092_060langle_062lb_M_Ab_M_Arb_092_060rangle_062_M_Aa_M_Ara_092_060rangle_062_A_061_AA_Ax_Alb_A_L_A_092_060phi_062_A_092_060langle_062ru_M_Ab_M_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_092_060rangle_062_A_L_A_092_060phi_062_A_092_060langle_062rb_M_Aa_M_Ara_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lb_M_Ab_M_Arb_092_060rangle_062_A_N_A_092_060phi_062_A_092_060langle_062lu_M_Au_M_Aru_092_060rangle_062_A_L_A1_092_060close_062,axiom,
    ( ( splay_266122055elle_A @ a @ xa @ ( node @ a @ ( node @ a @ lb @ b @ rb ) @ a2 @ ra ) )
    = ( plus_plus @ real @ ( minus_minus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( splay_266122055elle_A @ a @ xa @ lb ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lb @ b @ rb ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lu @ u @ ru ) ) ) ) ) @ ( one_one @ real ) ) ) ).

% \<open>A x \<langle>\<langle>lb, b, rb\<rangle>, a, ra\<rangle> = A x lb + \<phi> \<langle>ru, b, \<langle>rb, a, ra\<rangle>\<rangle> + \<phi> \<langle>rb, a, ra\<rangle> - \<phi> \<langle>lb, b, rb\<rangle> - \<phi> \<langle>lu, u, ru\<rangle> + 1\<close>
thf(fact_13_one__add__one,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ( ( plus_plus @ A @ ( one_one @ A ) @ ( one_one @ A ) )
        = ( numeral_numeral @ A @ ( bit0 @ one ) ) ) ) ).

% one_add_one
thf(fact_14_numeral__plus__one,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ N ) @ ( one_one @ A ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ N @ one ) ) ) ) ).

% numeral_plus_one
thf(fact_15_one__plus__numeral,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( plus_plus @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ N ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ one @ N ) ) ) ) ).

% one_plus_numeral
thf(fact_16_numeral__le__one__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( ord_less_eq @ A @ ( numeral_numeral @ A @ N ) @ ( one_one @ A ) )
          = ( ord_less_eq @ num @ N @ one ) ) ) ).

% numeral_le_one_iff
thf(fact_17_ld__ld__less2,axiom,
    ! [X: real,Y: real] :
      ( ( ord_less_eq @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ X )
     => ( ( ord_less_eq @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ Y )
       => ( ord_less_eq @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( one_one @ real ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ X ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ Y ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( minus_minus @ real @ ( plus_plus @ real @ X @ Y ) @ ( one_one @ real ) ) ) ) ) ) ) ).

% ld_ld_less2
thf(fact_18_numeral__eq__one__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( ( numeral_numeral @ A @ N )
            = ( one_one @ A ) )
          = ( N = one ) ) ) ).

% numeral_eq_one_iff
thf(fact_19_one__eq__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( ( one_one @ A )
            = ( numeral_numeral @ A @ N ) )
          = ( one = N ) ) ) ).

% one_eq_numeral_iff
thf(fact_20_left__diff__distrib__numeral,axiom,
    ! [A: $tType] :
      ( ( ( numeral @ A @ ( type @ A ) )
        & ( ring @ A @ ( type @ A ) ) )
     => ! [A2: A,B: A,V: num] :
          ( ( times_times @ A @ ( minus_minus @ A @ A2 @ B ) @ ( numeral_numeral @ A @ V ) )
          = ( minus_minus @ A @ ( times_times @ A @ A2 @ ( numeral_numeral @ A @ V ) ) @ ( times_times @ A @ B @ ( numeral_numeral @ A @ V ) ) ) ) ) ).

% left_diff_distrib_numeral
thf(fact_21_right__diff__distrib__numeral,axiom,
    ! [A: $tType] :
      ( ( ( numeral @ A @ ( type @ A ) )
        & ( ring @ A @ ( type @ A ) ) )
     => ! [V: num,B: A,C: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ V ) @ ( minus_minus @ A @ B @ C ) )
          = ( minus_minus @ A @ ( times_times @ A @ ( numeral_numeral @ A @ V ) @ B ) @ ( times_times @ A @ ( numeral_numeral @ A @ V ) @ C ) ) ) ) ).

% right_diff_distrib_numeral
thf(fact_22_distrib__left__numeral,axiom,
    ! [A: $tType] :
      ( ( ( numeral @ A @ ( type @ A ) )
        & ( semiring @ A @ ( type @ A ) ) )
     => ! [V: num,B: A,C: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ V ) @ ( plus_plus @ A @ B @ C ) )
          = ( plus_plus @ A @ ( times_times @ A @ ( numeral_numeral @ A @ V ) @ B ) @ ( times_times @ A @ ( numeral_numeral @ A @ V ) @ C ) ) ) ) ).

% distrib_left_numeral
thf(fact_23_num_Oinject_I1_J,axiom,
    ! [X2: num,Y2: num] :
      ( ( ( bit0 @ X2 )
        = ( bit0 @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% num.inject(1)
thf(fact_24_numeral__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [M: num,N: num] :
          ( ( ( numeral_numeral @ A @ M )
            = ( numeral_numeral @ A @ N ) )
          = ( M = N ) ) ) ).

% numeral_eq_iff
thf(fact_25_num_Oinject_I2_J,axiom,
    ! [X3: num,Y3: num] :
      ( ( ( bit1 @ X3 )
        = ( bit1 @ Y3 ) )
      = ( X3 = Y3 ) ) ).

% num.inject(2)
thf(fact_26_numeral__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: num,N: num] :
          ( ( ord_less @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( ord_less @ num @ M @ N ) ) ) ).

% numeral_less_iff
thf(fact_27_numeral__times__numeral,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type @ A ) )
     => ! [M: num,N: num] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( numeral_numeral @ A @ ( times_times @ num @ M @ N ) ) ) ) ).

% numeral_times_numeral
thf(fact_28_of__nat__numeral,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( semiring_1_of_nat @ A @ ( numeral_numeral @ nat @ N ) )
          = ( numeral_numeral @ A @ N ) ) ) ).

% of_nat_numeral
thf(fact_29_diff__numeral__special_I9_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type @ A ) )
     => ( ( minus_minus @ A @ ( one_one @ A ) @ ( one_one @ A ) )
        = ( zero_zero @ A ) ) ) ).

% diff_numeral_special(9)
thf(fact_30_distrib__right__numeral,axiom,
    ! [A: $tType] :
      ( ( ( numeral @ A @ ( type @ A ) )
        & ( semiring @ A @ ( type @ A ) ) )
     => ! [A2: A,B: A,V: num] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B ) @ ( numeral_numeral @ A @ V ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ ( numeral_numeral @ A @ V ) ) @ ( times_times @ A @ B @ ( numeral_numeral @ A @ V ) ) ) ) ) ).

% distrib_right_numeral
thf(fact_31_numeral__plus__numeral,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ! [M: num,N: num] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( numeral_numeral @ A @ ( plus_plus @ num @ M @ N ) ) ) ) ).

% numeral_plus_numeral
thf(fact_32_add__numeral__left,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ! [V: num,W: num,Z: A] :
          ( ( plus_plus @ A @ ( numeral_numeral @ A @ V ) @ ( plus_plus @ A @ ( numeral_numeral @ A @ W ) @ Z ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ ( plus_plus @ num @ V @ W ) ) @ Z ) ) ) ).

% add_numeral_left
thf(fact_33_numeral__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: num,N: num] :
          ( ( ord_less_eq @ A @ ( numeral_numeral @ A @ M ) @ ( numeral_numeral @ A @ N ) )
          = ( ord_less_eq @ num @ M @ N ) ) ) ).

% numeral_le_iff
thf(fact_34_A__simps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,L: tree @ A,R: tree @ A] :
          ( ( splay_266122055elle_A @ A @ A2 @ ( node @ A @ L @ A2 @ R ) )
          = ( one_one @ real ) ) ) ).

% A_simps(1)
thf(fact_35__C6_OIH_C,axiom,
    ( ( linorder_bst @ a @ lb )
   => ( ( member @ ( tree @ a ) @ ( node @ a @ lx @ xa @ rx ) @ ( subtrees @ a @ lb ) )
     => ( ord_less_eq @ real @ ( splay_266122055elle_A @ a @ xa @ lb ) @ ( plus_plus @ real @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( minus_minus @ real @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( one_one @ real ) ) ) ) ) ).

% "6.IH"
thf(fact_36_one__less__numeral__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( ord_less @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ N ) )
          = ( ord_less @ num @ one @ N ) ) ) ).

% one_less_numeral_iff
thf(fact_37_A__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [A2: A,B: A,Ll: tree @ A,Lr: tree @ A,R: tree @ A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( splay_266122055elle_A @ A @ A2 @ ( node @ A @ ( node @ A @ Ll @ A2 @ Lr ) @ B @ R ) )
            = ( plus_plus @ real @ ( minus_minus @ real @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ A @ ( node @ A @ Lr @ B @ R ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ A @ ( node @ A @ Ll @ A2 @ Lr ) ) ) ) ) @ ( one_one @ real ) ) ) ) ) ).

% A_simps(2)
thf(fact_38_A__simps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type @ A ) )
     => ! [B: A,A2: A,L: tree @ A,Rl: tree @ A,Rr: tree @ A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ( splay_266122055elle_A @ A @ A2 @ ( node @ A @ L @ B @ ( node @ A @ Rl @ A2 @ Rr ) ) )
            = ( plus_plus @ real @ ( minus_minus @ real @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ A @ ( node @ A @ Rl @ B @ L ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ A @ ( node @ A @ Rl @ A2 @ Rr ) ) ) ) ) @ ( one_one @ real ) ) ) ) ) ).

% A_simps(3)
thf(fact_39_numerals_I1_J,axiom,
    ( ( numeral_numeral @ nat @ one )
    = ( one_one @ nat ) ) ).

% numerals(1)
thf(fact_40_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_41_nat__1__add__1,axiom,
    ( ( plus_plus @ nat @ ( one_one @ nat ) @ ( one_one @ nat ) )
    = ( numeral_numeral @ nat @ ( bit0 @ one ) ) ) ).

% nat_1_add_1
thf(fact_42_add__One__commute,axiom,
    ! [N: num] :
      ( ( plus_plus @ num @ one @ N )
      = ( plus_plus @ num @ N @ one ) ) ).

% add_One_commute
thf(fact_43_le__num__One__iff,axiom,
    ! [X: num] :
      ( ( ord_less_eq @ num @ X @ one )
      = ( X = one ) ) ).

% le_num_One_iff
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
          = ( Q @ X5 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_not__numeral__less__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] :
          ~ ( ord_less @ A @ ( numeral_numeral @ A @ N ) @ ( zero_zero @ A ) ) ) ).

% not_numeral_less_zero
thf(fact_48_zero__less__numeral,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] : ( ord_less @ A @ ( zero_zero @ A ) @ ( numeral_numeral @ A @ N ) ) ) ).

% zero_less_numeral
thf(fact_49_less__numeral__extra_I1_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(1)
thf(fact_50_less__numeral__extra_I2_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(2)
thf(fact_51_less__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(4)
thf(fact_52_le__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% le_numeral_extra(3)
thf(fact_53_zero__neq__numeral,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( zero_zero @ A )
         != ( numeral_numeral @ A @ N ) ) ) ).

% zero_neq_numeral
thf(fact_54_is__num__normalize_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B ) @ C )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B @ C ) ) ) ) ).

% is_num_normalize(1)
thf(fact_55_not__numeral__less__one,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] :
          ~ ( ord_less @ A @ ( numeral_numeral @ A @ N ) @ ( one_one @ A ) ) ) ).

% not_numeral_less_one
thf(fact_56_not__numeral__le__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] :
          ~ ( ord_less_eq @ A @ ( numeral_numeral @ A @ N ) @ ( zero_zero @ A ) ) ) ).

% not_numeral_le_zero
thf(fact_57_zero__le__numeral,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( numeral_numeral @ A @ N ) ) ) ).

% zero_le_numeral
thf(fact_58_le__numeral__extra_I1_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% le_numeral_extra(1)
thf(fact_59_le__numeral__extra_I2_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less_eq @ A @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ).

% le_numeral_extra(2)
thf(fact_60_le__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ( ord_less_eq @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% le_numeral_extra(4)
thf(fact_61_num_Odistinct_I1_J,axiom,
    ! [X2: num] :
      ( one
     != ( bit0 @ X2 ) ) ).

% num.distinct(1)
thf(fact_62_num_Odistinct_I5_J,axiom,
    ! [X2: num,X3: num] :
      ( ( bit0 @ X2 )
     != ( bit1 @ X3 ) ) ).

% num.distinct(5)
thf(fact_63_num_Odistinct_I3_J,axiom,
    ! [X3: num] :
      ( one
     != ( bit1 @ X3 ) ) ).

% num.distinct(3)
thf(fact_64_ld__sum__inequality,axiom,
    ! [X: real,Y: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ Y )
       => ( ord_less_eq @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ X ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ Y ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( plus_plus @ real @ X @ Y ) ) ) ) ) ) ).

% ld_sum_inequality
thf(fact_65_ld__ld__1__less,axiom,
    ! [X: real,Y: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ Y )
       => ( ord_less @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( one_one @ real ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ X ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ Y ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( plus_plus @ real @ X @ Y ) ) ) ) ) ) ).

% ld_ld_1_less
thf(fact_66_one__le__numeral,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: num] : ( ord_less_eq @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ N ) ) ) ).

% one_le_numeral
thf(fact_67_numeral__Bit0,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( numeral_numeral @ A @ ( bit0 @ N ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ N ) @ ( numeral_numeral @ A @ N ) ) ) ) ).

% numeral_Bit0
thf(fact_68_mult__numeral__1__right,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( numeral_numeral @ A @ one ) )
          = A2 ) ) ).

% mult_numeral_1_right
thf(fact_69_mult__numeral__1,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ one ) @ A2 )
          = A2 ) ) ).

% mult_numeral_1
thf(fact_70_num_Oexhaust,axiom,
    ! [Y: num] :
      ( ( Y != one )
     => ( ! [X22: num] :
            ( Y
           != ( bit0 @ X22 ) )
       => ~ ! [X32: num] :
              ( Y
             != ( bit1 @ X32 ) ) ) ) ).

% num.exhaust
thf(fact_71_num_Oinduct,axiom,
    ! [P: num > $o,Num: num] :
      ( ( P @ one )
     => ( ! [X5: num] :
            ( ( P @ X5 )
           => ( P @ ( bit0 @ X5 ) ) )
       => ( ! [X5: num] :
              ( ( P @ X5 )
             => ( P @ ( bit1 @ X5 ) ) )
         => ( P @ Num ) ) ) ) ).

% num.induct
thf(fact_72_one__plus__numeral__commute,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ! [X: num] :
          ( ( plus_plus @ A @ ( one_one @ A ) @ ( numeral_numeral @ A @ X ) )
          = ( plus_plus @ A @ ( numeral_numeral @ A @ X ) @ ( one_one @ A ) ) ) ) ).

% one_plus_numeral_commute
thf(fact_73_numeral__One,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ( ( numeral_numeral @ A @ one )
        = ( one_one @ A ) ) ) ).

% numeral_One
thf(fact_74_log__sum__inequality,axiom,
    ! [X: real,Y: real,B: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ Y )
       => ( ( ord_less @ real @ ( one_one @ real ) @ B )
         => ( ord_less_eq @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ B @ ( numeral_numeral @ real @ ( bit0 @ one ) ) ) ) @ ( log @ B @ X ) ) @ ( log @ B @ Y ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ B @ ( plus_plus @ real @ X @ Y ) ) ) ) ) ) ) ).

% log_sum_inequality
thf(fact_75_numeral__Bit1,axiom,
    ! [A: $tType] :
      ( ( numeral @ A @ ( type @ A ) )
     => ! [N: num] :
          ( ( numeral_numeral @ A @ ( bit1 @ N ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ ( numeral_numeral @ A @ N ) @ ( numeral_numeral @ A @ N ) ) @ ( one_one @ A ) ) ) ) ).

% numeral_Bit1
thf(fact_76_mult__2__right,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ Z @ ( numeral_numeral @ A @ ( bit0 @ one ) ) )
          = ( plus_plus @ A @ Z @ Z ) ) ) ).

% mult_2_right
thf(fact_77_mult__2,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type @ A ) )
     => ! [Z: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ ( bit0 @ one ) ) @ Z )
          = ( plus_plus @ A @ Z @ Z ) ) ) ).

% mult_2
thf(fact_78_zero__le__log__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less_eq @ real @ ( zero_zero @ real ) @ ( log @ A2 @ X ) )
          = ( ord_less_eq @ real @ ( one_one @ real ) @ X ) ) ) ) ).

% zero_le_log_cancel_iff
thf(fact_79_log__le__zero__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less_eq @ real @ ( log @ A2 @ X ) @ ( zero_zero @ real ) )
          = ( ord_less_eq @ real @ X @ ( one_one @ real ) ) ) ) ) ).

% log_le_zero_cancel_iff
thf(fact_80_one__le__log__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less_eq @ real @ ( one_one @ real ) @ ( log @ A2 @ X ) )
          = ( ord_less_eq @ real @ A2 @ X ) ) ) ) ).

% one_le_log_cancel_iff
thf(fact_81_log__le__one__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less_eq @ real @ ( log @ A2 @ X ) @ ( one_one @ real ) )
          = ( ord_less_eq @ real @ X @ A2 ) ) ) ) ).

% log_le_one_cancel_iff
thf(fact_82_log__le__cancel__iff,axiom,
    ! [A2: real,X: real,Y: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ Y )
         => ( ( ord_less_eq @ real @ ( log @ A2 @ X ) @ ( log @ A2 @ Y ) )
            = ( ord_less_eq @ real @ X @ Y ) ) ) ) ) ).

% log_le_cancel_iff
thf(fact_83_zero__less__log__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( log @ A2 @ X ) )
          = ( ord_less @ real @ ( one_one @ real ) @ X ) ) ) ) ).

% zero_less_log_cancel_iff
thf(fact_84_log__less__zero__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less @ real @ ( log @ A2 @ X ) @ ( zero_zero @ real ) )
          = ( ord_less @ real @ X @ ( one_one @ real ) ) ) ) ) ).

% log_less_zero_cancel_iff
thf(fact_85_one__less__log__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less @ real @ ( one_one @ real ) @ ( log @ A2 @ X ) )
          = ( ord_less @ real @ A2 @ X ) ) ) ) ).

% one_less_log_cancel_iff
thf(fact_86_log__less__one__cancel__iff,axiom,
    ! [A2: real,X: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less @ real @ ( log @ A2 @ X ) @ ( one_one @ real ) )
          = ( ord_less @ real @ X @ A2 ) ) ) ) ).

% log_less_one_cancel_iff
thf(fact_87_log__less__cancel__iff,axiom,
    ! [A2: real,X: real,Y: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ A2 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ Y )
         => ( ( ord_less @ real @ ( log @ A2 @ X ) @ ( log @ A2 @ Y ) )
            = ( ord_less @ real @ X @ Y ) ) ) ) ) ).

% log_less_cancel_iff
thf(fact_88_log__one,axiom,
    ! [A2: real] :
      ( ( log @ A2 @ ( one_one @ real ) )
      = ( zero_zero @ real ) ) ).

% log_one
thf(fact_89_log__eq__one,axiom,
    ! [A2: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ A2 )
     => ( ( A2
         != ( one_one @ real ) )
       => ( ( log @ A2 @ A2 )
          = ( one_one @ real ) ) ) ) ).

% log_eq_one
thf(fact_90_zadd__int__left,axiom,
    ! [M: nat,N: nat,Z: int] :
      ( ( plus_plus @ int @ ( semiring_1_of_nat @ int @ M ) @ ( plus_plus @ int @ ( semiring_1_of_nat @ int @ N ) @ Z ) )
      = ( plus_plus @ int @ ( semiring_1_of_nat @ int @ ( plus_plus @ nat @ M @ N ) ) @ Z ) ) ).

% zadd_int_left
thf(fact_91_log__mult,axiom,
    ! [A2: real,X: real,Y: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ A2 )
     => ( ( A2
         != ( one_one @ real ) )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
         => ( ( ord_less @ real @ ( zero_zero @ real ) @ Y )
           => ( ( log @ A2 @ ( times_times @ real @ X @ Y ) )
              = ( plus_plus @ real @ ( log @ A2 @ X ) @ ( log @ A2 @ Y ) ) ) ) ) ) ) ).

% log_mult
thf(fact_92_semiring__norm_I79_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less @ num @ ( bit0 @ M ) @ ( bit1 @ N ) )
      = ( ord_less_eq @ num @ M @ N ) ) ).

% semiring_norm(79)
thf(fact_93_semiring__norm_I74_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ num @ ( bit1 @ M ) @ ( bit0 @ N ) )
      = ( ord_less @ num @ M @ N ) ) ).

% semiring_norm(74)
thf(fact_94_semiring__norm_I16_J,axiom,
    ! [M: num,N: num] :
      ( ( times_times @ num @ ( bit1 @ M ) @ ( bit1 @ N ) )
      = ( bit1 @ ( plus_plus @ num @ ( plus_plus @ num @ M @ N ) @ ( bit0 @ ( times_times @ num @ M @ N ) ) ) ) ) ).

% semiring_norm(16)
thf(fact_95_semiring__norm_I10_J,axiom,
    ! [M: num,N: num] :
      ( ( plus_plus @ num @ ( bit1 @ M ) @ ( bit1 @ N ) )
      = ( bit0 @ ( plus_plus @ num @ ( plus_plus @ num @ M @ N ) @ one ) ) ) ).

% semiring_norm(10)
thf(fact_96_semiring__norm_I8_J,axiom,
    ! [M: num] :
      ( ( plus_plus @ num @ ( bit1 @ M ) @ one )
      = ( bit0 @ ( plus_plus @ num @ M @ one ) ) ) ).

% semiring_norm(8)
thf(fact_97_semiring__norm_I5_J,axiom,
    ! [M: num] :
      ( ( plus_plus @ num @ ( bit0 @ M ) @ one )
      = ( bit1 @ M ) ) ).

% semiring_norm(5)
thf(fact_98_semiring__norm_I87_J,axiom,
    ! [M: num,N: num] :
      ( ( ( bit0 @ M )
        = ( bit0 @ N ) )
      = ( M = N ) ) ).

% semiring_norm(87)
thf(fact_99_semiring__norm_I90_J,axiom,
    ! [M: num,N: num] :
      ( ( ( bit1 @ M )
        = ( bit1 @ N ) )
      = ( M = N ) ) ).

% semiring_norm(90)
thf(fact_100_zle__add1__eq__le,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less @ int @ W @ ( plus_plus @ int @ Z @ ( one_one @ int ) ) )
      = ( ord_less_eq @ int @ W @ Z ) ) ).

% zle_add1_eq_le
thf(fact_101_semiring__norm_I83_J,axiom,
    ! [N: num] :
      ( one
     != ( bit0 @ N ) ) ).

% semiring_norm(83)
thf(fact_102_semiring__norm_I85_J,axiom,
    ! [M: num] :
      ( ( bit0 @ M )
     != one ) ).

% semiring_norm(85)
thf(fact_103_semiring__norm_I88_J,axiom,
    ! [M: num,N: num] :
      ( ( bit0 @ M )
     != ( bit1 @ N ) ) ).

% semiring_norm(88)
thf(fact_104_semiring__norm_I89_J,axiom,
    ! [M: num,N: num] :
      ( ( bit1 @ M )
     != ( bit0 @ N ) ) ).

% semiring_norm(89)
thf(fact_105_semiring__norm_I84_J,axiom,
    ! [N: num] :
      ( one
     != ( bit1 @ N ) ) ).

% semiring_norm(84)
thf(fact_106_semiring__norm_I86_J,axiom,
    ! [M: num] :
      ( ( bit1 @ M )
     != one ) ).

% semiring_norm(86)
thf(fact_107_semiring__norm_I6_J,axiom,
    ! [M: num,N: num] :
      ( ( plus_plus @ num @ ( bit0 @ M ) @ ( bit0 @ N ) )
      = ( bit0 @ ( plus_plus @ num @ M @ N ) ) ) ).

% semiring_norm(6)
thf(fact_108_semiring__norm_I13_J,axiom,
    ! [M: num,N: num] :
      ( ( times_times @ num @ ( bit0 @ M ) @ ( bit0 @ N ) )
      = ( bit0 @ ( bit0 @ ( times_times @ num @ M @ N ) ) ) ) ).

% semiring_norm(13)
thf(fact_109_semiring__norm_I11_J,axiom,
    ! [M: num] :
      ( ( times_times @ num @ M @ one )
      = M ) ).

% semiring_norm(11)
thf(fact_110_semiring__norm_I12_J,axiom,
    ! [N: num] :
      ( ( times_times @ num @ one @ N )
      = N ) ).

% semiring_norm(12)
thf(fact_111_semiring__norm_I71_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ num @ ( bit0 @ M ) @ ( bit0 @ N ) )
      = ( ord_less_eq @ num @ M @ N ) ) ).

% semiring_norm(71)
thf(fact_112_semiring__norm_I78_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less @ num @ ( bit0 @ M ) @ ( bit0 @ N ) )
      = ( ord_less @ num @ M @ N ) ) ).

% semiring_norm(78)
thf(fact_113_semiring__norm_I68_J,axiom,
    ! [N: num] : ( ord_less_eq @ num @ one @ N ) ).

% semiring_norm(68)
thf(fact_114_semiring__norm_I75_J,axiom,
    ! [M: num] :
      ~ ( ord_less @ num @ M @ one ) ).

% semiring_norm(75)
thf(fact_115_semiring__norm_I73_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ num @ ( bit1 @ M ) @ ( bit1 @ N ) )
      = ( ord_less_eq @ num @ M @ N ) ) ).

% semiring_norm(73)
thf(fact_116_semiring__norm_I80_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less @ num @ ( bit1 @ M ) @ ( bit1 @ N ) )
      = ( ord_less @ num @ M @ N ) ) ).

% semiring_norm(80)
thf(fact_117_semiring__norm_I2_J,axiom,
    ( ( plus_plus @ num @ one @ one )
    = ( bit0 @ one ) ) ).

% semiring_norm(2)
thf(fact_118_semiring__norm_I7_J,axiom,
    ! [M: num,N: num] :
      ( ( plus_plus @ num @ ( bit0 @ M ) @ ( bit1 @ N ) )
      = ( bit1 @ ( plus_plus @ num @ M @ N ) ) ) ).

% semiring_norm(7)
thf(fact_119_semiring__norm_I9_J,axiom,
    ! [M: num,N: num] :
      ( ( plus_plus @ num @ ( bit1 @ M ) @ ( bit0 @ N ) )
      = ( bit1 @ ( plus_plus @ num @ M @ N ) ) ) ).

% semiring_norm(9)
thf(fact_120_semiring__norm_I169_J,axiom,
    ! [A: $tType] :
      ( ( semiring_numeral @ A @ ( type @ A ) )
     => ! [V: num,W: num,Z: A] :
          ( ( times_times @ A @ ( numeral_numeral @ A @ V ) @ ( times_times @ A @ ( numeral_numeral @ A @ W ) @ Z ) )
          = ( times_times @ A @ ( numeral_numeral @ A @ ( times_times @ num @ V @ W ) ) @ Z ) ) ) ).

% semiring_norm(169)
thf(fact_121_semiring__norm_I14_J,axiom,
    ! [M: num,N: num] :
      ( ( times_times @ num @ ( bit0 @ M ) @ ( bit1 @ N ) )
      = ( bit0 @ ( times_times @ num @ M @ ( bit1 @ N ) ) ) ) ).

% semiring_norm(14)
thf(fact_122_semiring__norm_I15_J,axiom,
    ! [M: num,N: num] :
      ( ( times_times @ num @ ( bit1 @ M ) @ ( bit0 @ N ) )
      = ( bit0 @ ( times_times @ num @ ( bit1 @ M ) @ N ) ) ) ).

% semiring_norm(15)
thf(fact_123_semiring__norm_I69_J,axiom,
    ! [M: num] :
      ~ ( ord_less_eq @ num @ ( bit0 @ M ) @ one ) ).

% semiring_norm(69)
thf(fact_124_semiring__norm_I76_J,axiom,
    ! [N: num] : ( ord_less @ num @ one @ ( bit0 @ N ) ) ).

% semiring_norm(76)
thf(fact_125_semiring__norm_I72_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less_eq @ num @ ( bit0 @ M ) @ ( bit1 @ N ) )
      = ( ord_less_eq @ num @ M @ N ) ) ).

% semiring_norm(72)
thf(fact_126_semiring__norm_I81_J,axiom,
    ! [M: num,N: num] :
      ( ( ord_less @ num @ ( bit1 @ M ) @ ( bit0 @ N ) )
      = ( ord_less @ num @ M @ N ) ) ).

% semiring_norm(81)
thf(fact_127_semiring__norm_I70_J,axiom,
    ! [M: num] :
      ~ ( ord_less_eq @ num @ ( bit1 @ M ) @ one ) ).

% semiring_norm(70)
thf(fact_128_semiring__norm_I77_J,axiom,
    ! [N: num] : ( ord_less @ num @ one @ ( bit1 @ N ) ) ).

% semiring_norm(77)
thf(fact_129_semiring__norm_I3_J,axiom,
    ! [N: num] :
      ( ( plus_plus @ num @ one @ ( bit0 @ N ) )
      = ( bit1 @ N ) ) ).

% semiring_norm(3)
thf(fact_130_semiring__norm_I4_J,axiom,
    ! [N: num] :
      ( ( plus_plus @ num @ one @ ( bit1 @ N ) )
      = ( bit0 @ ( plus_plus @ num @ N @ one ) ) ) ).

% semiring_norm(4)
thf(fact_131_int__distrib_I2_J,axiom,
    ! [W: int,Z1: int,Z2: int] :
      ( ( times_times @ int @ W @ ( plus_plus @ int @ Z1 @ Z2 ) )
      = ( plus_plus @ int @ ( times_times @ int @ W @ Z1 ) @ ( times_times @ int @ W @ Z2 ) ) ) ).

% int_distrib(2)
thf(fact_132_int__distrib_I1_J,axiom,
    ! [Z1: int,Z2: int,W: int] :
      ( ( times_times @ int @ ( plus_plus @ int @ Z1 @ Z2 ) @ W )
      = ( plus_plus @ int @ ( times_times @ int @ Z1 @ W ) @ ( times_times @ int @ Z2 @ W ) ) ) ).

% int_distrib(1)
thf(fact_133_plus__int__code_I2_J,axiom,
    ! [L: int] :
      ( ( plus_plus @ int @ ( zero_zero @ int ) @ L )
      = L ) ).

% plus_int_code(2)
thf(fact_134_plus__int__code_I1_J,axiom,
    ! [K: int] :
      ( ( plus_plus @ int @ K @ ( zero_zero @ int ) )
      = K ) ).

% plus_int_code(1)
thf(fact_135_zle__int,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ int @ ( semiring_1_of_nat @ int @ M ) @ ( semiring_1_of_nat @ int @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% zle_int
thf(fact_136_int__induct,axiom,
    ! [P: int > $o,K: int,I: int] :
      ( ( P @ K )
     => ( ! [I2: int] :
            ( ( ord_less_eq @ int @ K @ I2 )
           => ( ( P @ I2 )
             => ( P @ ( plus_plus @ int @ I2 @ ( one_one @ int ) ) ) ) )
       => ( ! [I2: int] :
              ( ( ord_less_eq @ int @ I2 @ K )
             => ( ( P @ I2 )
               => ( P @ ( minus_minus @ int @ I2 @ ( one_one @ int ) ) ) ) )
         => ( P @ I ) ) ) ) ).

% int_induct
thf(fact_137_int__int__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ( semiring_1_of_nat @ int @ M )
        = ( semiring_1_of_nat @ int @ N ) )
      = ( M = N ) ) ).

% int_int_eq
thf(fact_138_add1__zle__eq,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less_eq @ int @ ( plus_plus @ int @ W @ ( one_one @ int ) ) @ Z )
      = ( ord_less @ int @ W @ Z ) ) ).

% add1_zle_eq
thf(fact_139_odd__nonzero,axiom,
    ! [Z: int] :
      ( ( plus_plus @ int @ ( plus_plus @ int @ ( one_one @ int ) @ Z ) @ Z )
     != ( zero_zero @ int ) ) ).

% odd_nonzero
thf(fact_140_zle__iff__zadd,axiom,
    ( ( ord_less_eq @ int )
    = ( ^ [W2: int,Z3: int] :
        ? [N2: nat] :
          ( Z3
          = ( plus_plus @ int @ W2 @ ( semiring_1_of_nat @ int @ N2 ) ) ) ) ) ).

% zle_iff_zadd
thf(fact_141_int__ge__induct,axiom,
    ! [K: int,I: int,P: int > $o] :
      ( ( ord_less_eq @ int @ K @ I )
     => ( ( P @ K )
       => ( ! [I2: int] :
              ( ( ord_less_eq @ int @ K @ I2 )
             => ( ( P @ I2 )
               => ( P @ ( plus_plus @ int @ I2 @ ( one_one @ int ) ) ) ) )
         => ( P @ I ) ) ) ) ).

% int_ge_induct
thf(fact_142_int__gr__induct,axiom,
    ! [K: int,I: int,P: int > $o] :
      ( ( ord_less @ int @ K @ I )
     => ( ( P @ ( plus_plus @ int @ K @ ( one_one @ int ) ) )
       => ( ! [I2: int] :
              ( ( ord_less @ int @ K @ I2 )
             => ( ( P @ I2 )
               => ( P @ ( plus_plus @ int @ I2 @ ( one_one @ int ) ) ) ) )
         => ( P @ I ) ) ) ) ).

% int_gr_induct
thf(fact_143_le__imp__0__less,axiom,
    ! [Z: int] :
      ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ Z )
     => ( ord_less @ int @ ( zero_zero @ int ) @ ( plus_plus @ int @ ( one_one @ int ) @ Z ) ) ) ).

% le_imp_0_less
thf(fact_144_nonneg__eq__int,axiom,
    ! [Z: int] :
      ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ Z )
     => ~ ! [M2: nat] :
            ( Z
           != ( semiring_1_of_nat @ int @ M2 ) ) ) ).

% nonneg_eq_int
thf(fact_145_zless__add1__eq,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less @ int @ W @ ( plus_plus @ int @ Z @ ( one_one @ int ) ) )
      = ( ( ord_less @ int @ W @ Z )
        | ( W = Z ) ) ) ).

% zless_add1_eq
thf(fact_146_int__diff__cases,axiom,
    ! [Z: int] :
      ~ ! [M2: nat,N3: nat] :
          ( Z
         != ( minus_minus @ int @ ( semiring_1_of_nat @ int @ M2 ) @ ( semiring_1_of_nat @ int @ N3 ) ) ) ).

% int_diff_cases
thf(fact_147_odd__less__0__iff,axiom,
    ! [Z: int] :
      ( ( ord_less @ int @ ( plus_plus @ int @ ( plus_plus @ int @ ( one_one @ int ) @ Z ) @ Z ) @ ( zero_zero @ int ) )
      = ( ord_less @ int @ Z @ ( zero_zero @ int ) ) ) ).

% odd_less_0_iff
thf(fact_148_nonneg__int__cases,axiom,
    ! [K: int] :
      ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ K )
     => ~ ! [N3: nat] :
            ( K
           != ( semiring_1_of_nat @ int @ N3 ) ) ) ).

% nonneg_int_cases
thf(fact_149_zero__le__imp__eq__int,axiom,
    ! [K: int] :
      ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ K )
     => ? [N3: nat] :
          ( K
          = ( semiring_1_of_nat @ int @ N3 ) ) ) ).

% zero_le_imp_eq_int
thf(fact_150_zless__imp__add1__zle,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less @ int @ W @ Z )
     => ( ord_less_eq @ int @ ( plus_plus @ int @ W @ ( one_one @ int ) ) @ Z ) ) ).

% zless_imp_add1_zle
thf(fact_151_zero__less__imp__eq__int,axiom,
    ! [K: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ K )
     => ? [N3: nat] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 )
          & ( K
            = ( semiring_1_of_nat @ int @ N3 ) ) ) ) ).

% zero_less_imp_eq_int
thf(fact_152_zmult__zless__mono2__lemma,axiom,
    ! [I: int,J: int,K: nat] :
      ( ( ord_less @ int @ I @ J )
     => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less @ int @ ( times_times @ int @ ( semiring_1_of_nat @ int @ K ) @ I ) @ ( times_times @ int @ ( semiring_1_of_nat @ int @ K ) @ J ) ) ) ) ).

% zmult_zless_mono2_lemma
thf(fact_153_left__add__mult__distrib,axiom,
    ! [I: nat,U2: nat,J: nat,K: nat] :
      ( ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ K ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ ( plus_plus @ nat @ I @ J ) @ U2 ) @ K ) ) ).

% left_add_mult_distrib
thf(fact_154_nat__less__add__iff2,axiom,
    ! [I: nat,J: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( ord_less @ nat @ M @ ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ J @ I ) @ U2 ) @ N ) ) ) ) ).

% nat_less_add_iff2
thf(fact_155_nat__less__add__iff1,axiom,
    ! [J: nat,I: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ J @ I )
     => ( ( ord_less @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( ord_less @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ I @ J ) @ U2 ) @ M ) @ N ) ) ) ).

% nat_less_add_iff1
thf(fact_156_nat__diff__add__eq2,axiom,
    ! [I: nat,J: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( minus_minus @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( minus_minus @ nat @ M @ ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ J @ I ) @ U2 ) @ N ) ) ) ) ).

% nat_diff_add_eq2
thf(fact_157_nat__diff__add__eq1,axiom,
    ! [J: nat,I: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ J @ I )
     => ( ( minus_minus @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( minus_minus @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ I @ J ) @ U2 ) @ M ) @ N ) ) ) ).

% nat_diff_add_eq1
thf(fact_158_nat__le__add__iff2,axiom,
    ! [I: nat,J: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( ord_less_eq @ nat @ M @ ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ J @ I ) @ U2 ) @ N ) ) ) ) ).

% nat_le_add_iff2
thf(fact_159_nat__le__add__iff1,axiom,
    ! [J: nat,I: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ J @ I )
     => ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( ord_less_eq @ nat @ ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ I @ J ) @ U2 ) @ M ) @ N ) ) ) ).

% nat_le_add_iff1
thf(fact_160_nat__eq__add__iff2,axiom,
    ! [I: nat,J: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M )
          = ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( M
          = ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ J @ I ) @ U2 ) @ N ) ) ) ) ).

% nat_eq_add_iff2
thf(fact_161_nat__eq__add__iff1,axiom,
    ! [J: nat,I: nat,U2: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ J @ I )
     => ( ( ( plus_plus @ nat @ ( times_times @ nat @ I @ U2 ) @ M )
          = ( plus_plus @ nat @ ( times_times @ nat @ J @ U2 ) @ N ) )
        = ( ( plus_plus @ nat @ ( times_times @ nat @ ( minus_minus @ nat @ I @ J ) @ U2 ) @ M )
          = N ) ) ) ).

% nat_eq_add_iff1
thf(fact_162_numeral__le__real__of__nat__iff,axiom,
    ! [N: num,M: nat] :
      ( ( ord_less_eq @ real @ ( numeral_numeral @ real @ N ) @ ( semiring_1_of_nat @ real @ M ) )
      = ( ord_less_eq @ nat @ ( numeral_numeral @ nat @ N ) @ M ) ) ).

% numeral_le_real_of_nat_iff
thf(fact_163_real__of__nat__less__numeral__iff,axiom,
    ! [N: nat,W: num] :
      ( ( ord_less @ real @ ( semiring_1_of_nat @ real @ N ) @ ( numeral_numeral @ real @ W ) )
      = ( ord_less @ nat @ N @ ( numeral_numeral @ nat @ W ) ) ) ).

% real_of_nat_less_numeral_iff
thf(fact_164_numeral__less__real__of__nat__iff,axiom,
    ! [W: num,N: nat] :
      ( ( ord_less @ real @ ( numeral_numeral @ real @ W ) @ ( semiring_1_of_nat @ real @ N ) )
      = ( ord_less @ nat @ ( numeral_numeral @ nat @ W ) @ N ) ) ).

% numeral_less_real_of_nat_iff
thf(fact_165_real__mult__le__cancel__iff2,axiom,
    ! [Z: real,X: real,Y: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ Z )
     => ( ( ord_less_eq @ real @ ( times_times @ real @ Z @ X ) @ ( times_times @ real @ Z @ Y ) )
        = ( ord_less_eq @ real @ X @ Y ) ) ) ).

% real_mult_le_cancel_iff2
thf(fact_166_real__mult__le__cancel__iff1,axiom,
    ! [Z: real,X: real,Y: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ Z )
     => ( ( ord_less_eq @ real @ ( times_times @ real @ X @ Z ) @ ( times_times @ real @ Y @ Z ) )
        = ( ord_less_eq @ real @ X @ Y ) ) ) ).

% real_mult_le_cancel_iff1
thf(fact_167_nat__mult__less__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% nat_mult_less_cancel_disj
thf(fact_168_real__mult__less__iff1,axiom,
    ! [Z: real,X: real,Y: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ Z )
     => ( ( ord_less @ real @ ( times_times @ real @ X @ Z ) @ ( times_times @ real @ Y @ Z ) )
        = ( ord_less @ real @ X @ Y ) ) ) ).

% real_mult_less_iff1
thf(fact_169_nat__mult__le__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less_eq @ nat @ M @ N ) ) ) ).

% nat_mult_le_cancel_disj
thf(fact_170_zle__diff1__eq,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less_eq @ int @ W @ ( minus_minus @ int @ Z @ ( one_one @ int ) ) )
      = ( ord_less @ int @ W @ Z ) ) ).

% zle_diff1_eq
thf(fact_171_nat__mult__eq__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
     => ( ( ( times_times @ nat @ K @ M )
          = ( times_times @ nat @ K @ N ) )
        = ( M = N ) ) ) ).

% nat_mult_eq_cancel1
thf(fact_172_nat__mult__le__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
     => ( ( ord_less_eq @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
        = ( ord_less_eq @ nat @ M @ N ) ) ) ).

% nat_mult_le_cancel1
thf(fact_173_nat__mult__less__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
     => ( ( ord_less @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
        = ( ord_less @ nat @ M @ N ) ) ) ).

% nat_mult_less_cancel1
thf(fact_174_nat__mult__eq__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( K
          = ( zero_zero @ nat ) )
        | ( M = N ) ) ) ).

% nat_mult_eq_cancel_disj
thf(fact_175_int__one__le__iff__zero__less,axiom,
    ! [Z: int] :
      ( ( ord_less_eq @ int @ ( one_one @ int ) @ Z )
      = ( ord_less @ int @ ( zero_zero @ int ) @ Z ) ) ).

% int_one_le_iff_zero_less
thf(fact_176_pos__zmult__eq__1__iff,axiom,
    ! [M: int,N: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ M )
     => ( ( ( times_times @ int @ M @ N )
          = ( one_one @ int ) )
        = ( ( M
            = ( one_one @ int ) )
          & ( N
            = ( one_one @ int ) ) ) ) ) ).

% pos_zmult_eq_1_iff
thf(fact_177_zmult__zless__mono2,axiom,
    ! [I: int,J: int,K: int] :
      ( ( ord_less @ int @ I @ J )
     => ( ( ord_less @ int @ ( zero_zero @ int ) @ K )
       => ( ord_less @ int @ ( times_times @ int @ K @ I ) @ ( times_times @ int @ K @ J ) ) ) ) ).

% zmult_zless_mono2
thf(fact_178_int__less__induct,axiom,
    ! [I: int,K: int,P: int > $o] :
      ( ( ord_less @ int @ I @ K )
     => ( ( P @ ( minus_minus @ int @ K @ ( one_one @ int ) ) )
       => ( ! [I2: int] :
              ( ( ord_less @ int @ I2 @ K )
             => ( ( P @ I2 )
               => ( P @ ( minus_minus @ int @ I2 @ ( one_one @ int ) ) ) ) )
         => ( P @ I ) ) ) ) ).

% int_less_induct
thf(fact_179_int__le__induct,axiom,
    ! [I: int,K: int,P: int > $o] :
      ( ( ord_less_eq @ int @ I @ K )
     => ( ( P @ K )
       => ( ! [I2: int] :
              ( ( ord_less_eq @ int @ I2 @ K )
             => ( ( P @ I2 )
               => ( P @ ( minus_minus @ int @ I2 @ ( one_one @ int ) ) ) ) )
         => ( P @ I ) ) ) ) ).

% int_le_induct
thf(fact_180_less__eq__int__code_I1_J,axiom,
    ord_less_eq @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ).

% less_eq_int_code(1)
thf(fact_181_times__int__code_I1_J,axiom,
    ! [K: int] :
      ( ( times_times @ int @ K @ ( zero_zero @ int ) )
      = ( zero_zero @ int ) ) ).

% times_int_code(1)
thf(fact_182_times__int__code_I2_J,axiom,
    ! [L: int] :
      ( ( times_times @ int @ ( zero_zero @ int ) @ L )
      = ( zero_zero @ int ) ) ).

% times_int_code(2)
thf(fact_183_minus__int__code_I1_J,axiom,
    ! [K: int] :
      ( ( minus_minus @ int @ K @ ( zero_zero @ int ) )
      = K ) ).

% minus_int_code(1)
thf(fact_184_less__int__code_I1_J,axiom,
    ~ ( ord_less @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ) ).

% less_int_code(1)
thf(fact_185_int__distrib_I3_J,axiom,
    ! [Z1: int,Z2: int,W: int] :
      ( ( times_times @ int @ ( minus_minus @ int @ Z1 @ Z2 ) @ W )
      = ( minus_minus @ int @ ( times_times @ int @ Z1 @ W ) @ ( times_times @ int @ Z2 @ W ) ) ) ).

% int_distrib(3)
thf(fact_186_int__distrib_I4_J,axiom,
    ! [W: int,Z1: int,Z2: int] :
      ( ( times_times @ int @ W @ ( minus_minus @ int @ Z1 @ Z2 ) )
      = ( minus_minus @ int @ ( times_times @ int @ W @ Z1 ) @ ( times_times @ int @ W @ Z2 ) ) ) ).

% int_distrib(4)
thf(fact_187_complete__real,axiom,
    ! [S: set @ real] :
      ( ? [X6: real] : ( member @ real @ X6 @ S )
     => ( ? [Z4: real] :
          ! [X5: real] :
            ( ( member @ real @ X5 @ S )
           => ( ord_less_eq @ real @ X5 @ Z4 ) )
       => ? [Y4: real] :
            ( ! [X6: real] :
                ( ( member @ real @ X6 @ S )
               => ( ord_less_eq @ real @ X6 @ Y4 ) )
            & ! [Z4: real] :
                ( ! [X5: real] :
                    ( ( member @ real @ X5 @ S )
                   => ( ord_less_eq @ real @ X5 @ Z4 ) )
               => ( ord_less_eq @ real @ Y4 @ Z4 ) ) ) ) ) ).

% complete_real
thf(fact_188_add__diff__add,axiom,
    ! [A: $tType] :
      ( ( ab_group_add @ A @ ( type @ A ) )
     => ! [A2: A,C: A,B: A,D: A] :
          ( ( minus_minus @ A @ ( plus_plus @ A @ A2 @ C ) @ ( plus_plus @ A @ B @ D ) )
          = ( plus_plus @ A @ ( minus_minus @ A @ A2 @ B ) @ ( minus_minus @ A @ C @ D ) ) ) ) ).

% add_diff_add
thf(fact_189_real__lbound__gt__zero,axiom,
    ! [D1: real,D2: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ D1 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ D2 )
       => ? [E: real] :
            ( ( ord_less @ real @ ( zero_zero @ real ) @ E )
            & ( ord_less @ real @ E @ D1 )
            & ( ord_less @ real @ E @ D2 ) ) ) ) ).

% real_lbound_gt_zero
thf(fact_190_less__eq__real__def,axiom,
    ( ( ord_less_eq @ real )
    = ( ^ [X4: real,Y5: real] :
          ( ( ord_less @ real @ X4 @ Y5 )
          | ( X4 = Y5 ) ) ) ) ).

% less_eq_real_def
thf(fact_191_mult__diff__mult,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type @ A ) )
     => ! [X: A,Y: A,A2: A,B: A] :
          ( ( minus_minus @ A @ ( times_times @ A @ X @ Y ) @ ( times_times @ A @ A2 @ B ) )
          = ( plus_plus @ A @ ( times_times @ A @ X @ ( minus_minus @ A @ Y @ B ) ) @ ( times_times @ A @ ( minus_minus @ A @ X @ A2 ) @ B ) ) ) ) ).

% mult_diff_mult
thf(fact_192_reals__Archimedean3,axiom,
    ! [X: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ X )
     => ! [Y6: real] :
        ? [N3: nat] : ( ord_less @ real @ Y6 @ ( times_times @ real @ ( semiring_1_of_nat @ real @ N3 ) @ X ) ) ) ).

% reals_Archimedean3
thf(fact_193_real__archimedian__rdiv__eq__0,axiom,
    ! [X: real,C: real] :
      ( ( ord_less_eq @ real @ ( zero_zero @ real ) @ X )
     => ( ( ord_less_eq @ real @ ( zero_zero @ real ) @ C )
       => ( ! [M2: nat] :
              ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M2 )
             => ( ord_less_eq @ real @ ( times_times @ real @ ( semiring_1_of_nat @ real @ M2 ) @ X ) @ C ) )
         => ( X
            = ( zero_zero @ real ) ) ) ) ) ).

% real_archimedian_rdiv_eq_0
thf(fact_194_nat__le__real__less,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [N2: nat,M3: nat] : ( ord_less @ real @ ( semiring_1_of_nat @ real @ N2 ) @ ( plus_plus @ real @ ( semiring_1_of_nat @ real @ M3 ) @ ( one_one @ real ) ) ) ) ) ).

% nat_le_real_less
thf(fact_195_nat__less__real__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [N2: nat,M3: nat] : ( ord_less_eq @ real @ ( plus_plus @ real @ ( semiring_1_of_nat @ real @ N2 ) @ ( one_one @ real ) ) @ ( semiring_1_of_nat @ real @ M3 ) ) ) ) ).

% nat_less_real_le
thf(fact_196_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% of_nat_0_less_iff
thf(fact_197_mult__le__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less_eq @ nat @ M @ N ) ) ) ).

% mult_le_cancel2
thf(fact_198_of__nat__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: nat] :
          ( ( ord_less_eq @ A @ ( semiring_1_of_nat @ A @ M ) @ ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_le_0_iff
thf(fact_199_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( semiring_1_of_nat @ A @ N ) )
          = ( M = N ) ) ) ).

% of_nat_eq_iff
thf(fact_200_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_201_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_202_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_203_le0,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ ( zero_zero @ nat ) @ N ) ).

% le0
thf(fact_204_mult__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% mult_is_0
thf(fact_205_mult__0__right,axiom,
    ! [M: nat] :
      ( ( times_times @ nat @ M @ ( zero_zero @ nat ) )
      = ( zero_zero @ nat ) ) ).

% mult_0_right
thf(fact_206_mult__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel1
thf(fact_207_mult__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ K )
        = ( times_times @ nat @ N @ K ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel2
thf(fact_208_diff__0__eq__0,axiom,
    ! [N: nat] :
      ( ( minus_minus @ nat @ ( zero_zero @ nat ) @ N )
      = ( zero_zero @ nat ) ) ).

% diff_0_eq_0
thf(fact_209_diff__self__eq__0,axiom,
    ! [M: nat] :
      ( ( minus_minus @ nat @ M @ M )
      = ( zero_zero @ nat ) ) ).

% diff_self_eq_0
thf(fact_210_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_211_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_212_diff__diff__left,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( minus_minus @ nat @ ( minus_minus @ nat @ I @ J ) @ K )
      = ( minus_minus @ nat @ I @ ( plus_plus @ nat @ J @ K ) ) ) ).

% diff_diff_left
thf(fact_213_diff__diff__cancel,axiom,
    ! [I: nat,N: nat] :
      ( ( ord_less_eq @ nat @ I @ N )
     => ( ( minus_minus @ nat @ N @ ( minus_minus @ nat @ N @ I ) )
        = I ) ) ).

% diff_diff_cancel
thf(fact_214_nat__mult__eq__1__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ N )
        = ( one_one @ nat ) )
      = ( ( M
          = ( one_one @ nat ) )
        & ( N
          = ( one_one @ nat ) ) ) ) ).

% nat_mult_eq_1_iff
thf(fact_215_nat__1__eq__mult__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( one_one @ nat )
        = ( times_times @ nat @ M @ N ) )
      = ( ( M
          = ( one_one @ nat ) )
        & ( N
          = ( one_one @ nat ) ) ) ) ).

% nat_1_eq_mult_iff
thf(fact_216_of__nat__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [M: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_eq_0_iff
thf(fact_217_of__nat__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [N: nat] :
          ( ( ( zero_zero @ A )
            = ( semiring_1_of_nat @ A @ N ) )
          = ( ( zero_zero @ nat )
            = N ) ) ) ).

% of_nat_0_eq_iff
thf(fact_218_of__nat__0,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ( ( semiring_1_of_nat @ A @ ( zero_zero @ nat ) )
        = ( zero_zero @ A ) ) ) ).

% of_nat_0
thf(fact_219_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less @ nat @ M @ N ) ) ) ).

% of_nat_less_iff
thf(fact_220_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( ord_less_eq @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less_eq @ nat @ M @ N ) ) ) ).

% of_nat_le_iff
thf(fact_221_of__nat__add,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( semiring_1_of_nat @ A @ ( plus_plus @ nat @ M @ N ) )
          = ( plus_plus @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) ) ) ) ).

% of_nat_add
thf(fact_222_of__nat__mult,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( semiring_1_of_nat @ A @ ( times_times @ nat @ M @ N ) )
          = ( times_times @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) ) ) ) ).

% of_nat_mult
thf(fact_223_of__nat__1,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ( ( semiring_1_of_nat @ A @ ( one_one @ nat ) )
        = ( one_one @ A ) ) ) ).

% of_nat_1
thf(fact_224_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( plus_plus @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        | ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% add_gr_0
thf(fact_225_mult__less__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% mult_less_cancel2
thf(fact_226_nat__0__less__mult__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( times_times @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        & ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% nat_0_less_mult_iff
thf(fact_227_zero__less__diff,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( minus_minus @ nat @ N @ M ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% zero_less_diff
thf(fact_228_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( one_one @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_one
thf(fact_229_diff__is__0__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ( minus_minus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ord_less_eq @ nat @ M @ N ) ) ).

% diff_is_0_eq
thf(fact_230_diff__is__0__eq_H,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( minus_minus @ nat @ M @ N )
        = ( zero_zero @ nat ) ) ) ).

% diff_is_0_eq'
thf(fact_231_Nat_Odiff__diff__right,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ( ord_less_eq @ nat @ K @ J )
     => ( ( minus_minus @ nat @ I @ ( minus_minus @ nat @ J @ K ) )
        = ( minus_minus @ nat @ ( plus_plus @ nat @ I @ K ) @ J ) ) ) ).

% Nat.diff_diff_right
thf(fact_232_Nat_Oadd__diff__assoc2,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ( ord_less_eq @ nat @ K @ J )
     => ( ( plus_plus @ nat @ ( minus_minus @ nat @ J @ K ) @ I )
        = ( minus_minus @ nat @ ( plus_plus @ nat @ J @ I ) @ K ) ) ) ).

% Nat.add_diff_assoc2
thf(fact_233_Nat_Oadd__diff__assoc,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ( ord_less_eq @ nat @ K @ J )
     => ( ( plus_plus @ nat @ I @ ( minus_minus @ nat @ J @ K ) )
        = ( minus_minus @ nat @ ( plus_plus @ nat @ I @ J ) @ K ) ) ) ).

% Nat.add_diff_assoc
thf(fact_234_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_235_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_236_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_237_less__not__refl3,axiom,
    ! [S2: nat,T: nat] :
      ( ( ord_less @ nat @ S2 @ T )
     => ( S2 != T ) ) ).

% less_not_refl3
thf(fact_238_measure__induct,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X5: A] :
          ( ! [Y6: A] :
              ( ( ord_less @ nat @ ( F @ Y6 ) @ ( F @ X5 ) )
             => ( P @ Y6 ) )
         => ( P @ X5 ) )
     => ( P @ A2 ) ) ).

% measure_induct
thf(fact_239_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_240_nat__less__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ! [M4: nat] :
              ( ( ord_less @ nat @ M4 @ N3 )
             => ( P @ M4 ) )
         => ( P @ N3 ) )
     => ( P @ N ) ) ).

% nat_less_induct
thf(fact_241_infinite__descent,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N3: nat] :
          ( ~ ( P @ N3 )
         => ? [M4: nat] :
              ( ( ord_less @ nat @ M4 @ N3 )
              & ~ ( P @ M4 ) ) )
     => ( P @ N ) ) ).

% infinite_descent
thf(fact_242_linorder__neqE__nat,axiom,
    ! [X: nat,Y: nat] :
      ( ( X != Y )
     => ( ~ ( ord_less @ nat @ X @ Y )
       => ( ord_less @ nat @ Y @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_243_measure__induct__rule,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X5: A] :
          ( ! [Y6: A] :
              ( ( ord_less @ nat @ ( F @ Y6 ) @ ( F @ X5 ) )
             => ( P @ Y6 ) )
         => ( P @ X5 ) )
     => ( P @ A2 ) ) ).

% measure_induct_rule
thf(fact_244_infinite__descent__measure,axiom,
    ! [A: $tType,P: A > $o,V2: A > nat,X: A] :
      ( ! [X5: A] :
          ( ~ ( P @ X5 )
         => ? [Y6: A] :
              ( ( ord_less @ nat @ ( V2 @ Y6 ) @ ( V2 @ X5 ) )
              & ~ ( P @ Y6 ) ) )
     => ( P @ X ) ) ).

% infinite_descent_measure
thf(fact_245_nat__add__right__cancel,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ K )
        = ( plus_plus @ nat @ N @ K ) )
      = ( M = N ) ) ).

% nat_add_right_cancel
thf(fact_246_nat__add__left__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ K @ M )
        = ( plus_plus @ nat @ K @ N ) )
      = ( M = N ) ) ).

% nat_add_left_cancel
thf(fact_247_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
      | ( ord_less_eq @ nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_248_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq @ nat @ M @ N )
     => ( ( ord_less_eq @ nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_249_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq @ nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_250_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I @ K ) ) ) ).

% le_trans
thf(fact_251_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq @ nat @ N @ N ) ).

% le_refl
thf(fact_252_diff__commute,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( minus_minus @ nat @ ( minus_minus @ nat @ I @ J ) @ K )
      = ( minus_minus @ nat @ ( minus_minus @ nat @ I @ K ) @ J ) ) ).

% diff_commute

%----Type constructors (29)
thf(tcon_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Num_Osemiring__numeral,axiom,
    semiring_numeral @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oab__group__add,axiom,
    ab_group_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Orderings_Olinorder,axiom,
    linorder @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Num_Oneg__numeral,axiom,
    neg_numeral @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring,axiom,
    semiring @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Num_Onumeral,axiom,
    numeral @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Oring,axiom,
    ring @ int @ ( type @ int ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom_1,axiom,
    linordered_semidom @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Num_Osemiring__numeral_2,axiom,
    semiring_numeral @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0_3,axiom,
    semiring_char_0 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder_4,axiom,
    linorder @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__1_5,axiom,
    semiring_1 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring_6,axiom,
    semiring @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Num_Onumeral_7,axiom,
    numeral @ nat @ ( type @ nat ) ).

thf(tcon_Num_Onum___Orderings_Olinorder_8,axiom,
    linorder @ num @ ( type @ num ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_9,axiom,
    linorder @ $o @ ( type @ $o ) ).

thf(tcon_Real_Oreal___Rings_Olinordered__semidom_10,axiom,
    linordered_semidom @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Num_Osemiring__numeral_11,axiom,
    semiring_numeral @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Nat_Osemiring__char__0_12,axiom,
    semiring_char_0 @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Groups_Oab__group__add_13,axiom,
    ab_group_add @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Orderings_Olinorder_14,axiom,
    linorder @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Osemiring__1_15,axiom,
    semiring_1 @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Num_Oneg__numeral_16,axiom,
    neg_numeral @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Osemiring_17,axiom,
    semiring @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Num_Onumeral_18,axiom,
    numeral @ real @ ( type @ real ) ).

thf(tcon_Real_Oreal___Rings_Oring_19,axiom,
    ring @ real @ ( type @ real ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ord_less_eq @ real @ ( plus_plus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( plus_plus @ real @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ lb ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( numeral_numeral @ real @ ( bit0 @ one ) ) ) @ ( plus_plus @ real @ ( minus_minus @ real @ ( plus_plus @ real @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ru @ b @ ( node @ a @ rb @ a2 @ ra ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ ( node @ a @ lb @ b @ rb ) @ a2 @ ra ) ) ) ) ) ) @ ( times_times @ real @ ( numeral_numeral @ real @ ( bit1 @ one ) ) @ ( log @ ( numeral_numeral @ real @ ( bit0 @ one ) ) @ ( semiring_1_of_nat @ real @ ( size1 @ a @ ( node @ a @ lx @ xa @ rx ) ) ) ) ) ) @ ( one_one @ real ) ) ).

%------------------------------------------------------------------------------
